<?php
// send_sms.php - A utility for sending SMS via Hubtel API.

/**
 * Sends an SMS message using the Hubtel API.
 *
 * @param string $to The recipient's phone number in +233 format.
 * @param string $message The content of the SMS message.
 * @return bool True on success, false on failure.
 */
function send_sms($to, $message) {
    // A simple logging function for this file.
    // Assumes a log_debug function might be available in the including script's context.
    if (!function_exists('log_debug')) {
        function log_debug($msg) {
            error_log($msg);
        }
    }

    // Basic validation for phone number format.
    $cleaned_phone = str_replace(' ', '', $to);
    if (!preg_match('/^\+233\d{9}$/', $cleaned_phone)) {
        log_debug("send_sms: Invalid phone number format provided: $to");
        return false;
    }

    // Hubtel API credentials and endpoint.
    // It is strongly recommended to move these into a secure configuration file and not commit them to version control.
    $apiUsername = "jrfklupa";
    $apiPassword = "yvyyeoam";
    $senderId = 'KrolaBills'; // Using a more relevant sender ID for this project.
    $apiUrl = "https://smsc.hubtel.com/v1/messages/send";

    // Prepare headers for Hubtel API request.
    $headers = [
        "Authorization: Basic " . base64_encode("$apiUsername:$apiPassword"),
        "Content-Type: application/json"
    ];

    // Prepare the data payload for the API.
    $fields = [
        'From' => $senderId,
        'To' => $cleaned_phone,
        'Content' => $message,
        'ClientReference' => 'krolabills-' . uniqid() // Add a prefix for easier tracking.
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Hubtel's API typically returns a 201 status on successful message submission.
    if ($httpCode >= 200 && $httpCode < 300) {
        log_debug("SMS submitted successfully to $cleaned_phone. API Response: $response");
        return true;
    } else {
        log_debug("Failed to send SMS to $cleaned_phone. HTTP Code: $httpCode, API Response: $response");
        return false;
    }
}
?>