<?php
include 'db_config.php';
include 'send_sms.php';
check_login();

$message = '';
$message_type = '';

try {
    // 1. Fetch clients with pending invoices and the months of those invoices
    $stmt = $pdo->query("
        SELECT DISTINCT c.name, c.phone_number, GROUP_CONCAT(DISTINCT MONTHNAME(i.invoice_date) ORDER BY i.invoice_date) as overdue_months
        FROM clients c
        JOIN invoices i ON c.client_id = i.client_id
        WHERE i.status = 'Pending'
        GROUP BY c.client_id
    ");
    $clients_to_remind = $stmt->fetchAll();

    if (empty($clients_to_remind)) {
        $message = "No clients with pending invoices found.";
        $message_type = 'info';
    } else {
        $sent_count = 0;
        foreach ($clients_to_remind as $client) {
            // 2. Format the SMS message
            $phone_ending = substr($client['phone_number'], -4);
            $sms_message = "Dear {$client['name']}, kindly note your {$client['overdue_months']} invoices are overdue. To ensure your continuous service, please make a prompt payment. Please pay via *203*333*1#, using your phone number ending **{$phone_ending}. Thank you for your swift attention.";

            // 3. Send the SMS
            if (send_sms($client['phone_number'], $sms_message)) {
                $sent_count++;
            }
        }
        $message = "Successfully sent reminders to $sent_count client(s).";
        $message_type = 'success';
    }
} catch (\PDOException $e) {
    $message = "Database error: " . $e->getMessage();
    $message_type = 'danger';
}

$_SESSION['flash_message'] = $message;
$_SESSION['flash_message_type'] = $message_type;
header('Location: index.php');
exit;
?>