<?php
include 'db_config.php';
check_login();

// Fetch Invoices and join with Client name
$sql = "SELECT 
            i.*, 
            c.name AS client_name, 
            c.phone_number
        FROM invoices i
        JOIN clients c ON i.client_id = c.client_id
        ORDER BY i.invoice_date DESC";
$invoices = $pdo->query($sql)->fetchAll();

$active_page = 'dashboard';
include 'navbar.php'; 
?>

<div class="container mt-5">

    <?php if (isset($_SESSION['flash_message'])): ?>
        <div class="alert alert-<?= $_SESSION['flash_message_type'] ?> alert-dismissible fade show" role="alert">
            <?= $_SESSION['flash_message'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
        <?php
        unset($_SESSION['flash_message']);
        unset($_SESSION['flash_message_type']);
        ?>
    <?php endif; ?>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>🧾 Invoice Dashboard</h2>
        <div>
            <a href="add_client.php" class="btn btn-success me-2">Add Client</a>
            <a href="add_invoice.php" class="btn btn-primary">Create Invoice</a>
        </div>
    </div>

    <div class="table-responsive">
        <table class="table table-striped table-hover shadow-sm">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>Client</th>
                    <th>Invoice No.</th>
                    <th>Total (GHS)</th>
                    <th>Date</th>
                    <th>Status</th>
                    <th>Due Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($invoices)): ?>
                    <tr>
                        <td colspan="8" class="text-center">No invoices found. Start by creating one!</td>
                    </tr>
                <?php else: ?>
                    <?php foreach ($invoices as $invoice): ?>
                        <tr>
                            <td><?= $invoice['invoice_id'] ?></td>
                            <td><?= htmlspecialchars($invoice['client_name']) ?></td>
                            <td><?= htmlspecialchars($invoice['invoice_number']) ?></td>
                            <td>**<?= number_format($invoice['total'], 2) ?>**</td>
                            <td><?= date('M d, Y', strtotime($invoice['invoice_date'])) ?></td>
                            <td>
                                <?php
                                $status = $invoice['status'];
                                $badge_class = 'secondary'; // Default

                                // **FIXED CODE: Using switch statement for PHP 7.x compatibility**
                                switch ($status) {
                                    case 'Paid':
                                        $badge_class = 'success';
                                        break;
                                    case 'Pending':
                                        $badge_class = 'warning';
                                        break;
                                    case 'Cancelled':
                                        $badge_class = 'danger';
                                        break;
                                }
                                ?>
                                <span class="badge bg-<?= $badge_class ?>"><?= $status ?></span>
                            </td>
                            <td>
                                <?= $invoice['due_date'] ? date('M d, Y', strtotime($invoice['due_date'])) : 'N/A' ?>
                            </td>
                            <td>
                                <a href="view_invoice.php?id=<?= $invoice['invoice_id'] ?>" class="btn btn-sm btn-info text-white">View</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'footer.php'; ?>