<?php
include 'db_config.php';
check_login();

$message = '';
$message_type = '';

// 1. Fetch Clients for the dropdown
$clients = $pdo->query('SELECT client_id, name FROM clients ORDER BY name ASC')->fetchAll();

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect and sanitize data
    $client_id = $_POST['client_id'];
    $invoice_number = trim($_POST['invoice_number']);
    $details = trim($_POST['details']);
    $description = trim($_POST['description']);
    $total = (float)$_POST['total'];
    $status = $_POST['status'];
    $invoice_date = $_POST['invoice_date'];
    $due_date = $_POST['due_date'];
    $paid_date = !empty($_POST['paid_date']) ? $_POST['paid_date'] : NULL;

    // Minimal Validation
    if (empty($client_id) || empty($invoice_number) || empty($total) || empty($invoice_date)) {
        $message = "Please fill in all required fields (Client, Number, Total, Invoice Date).";
        $message_type = 'danger';
    } else {
        try {
            $sql = "INSERT INTO invoices (client_id, invoice_number, details, description, total, status, invoice_date, due_date, paid_date) 
                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                $client_id, $invoice_number, $details, $description, $total, $status, $invoice_date, $due_date, $paid_date
            ]);
            $message = "Invoice **$invoice_number** created successfully!";
            $message_type = 'success';
        } catch (\PDOException $e) {
            if ($e->getCode() == 23000) {
                $message = "Error: Invoice number **$invoice_number** already exists.";
            } else {
                $message = "An unexpected database error occurred.";
            }
            $message_type = 'danger';
        }
    }
}

$active_page = 'add_invoice';
include 'navbar.php'; 
?>

<div class="container mt-5">
    <h2 class="mb-4">📝 Create New Invoice</h2>

    <?php if ($message): ?>
        <div class="alert alert-<?= $message_type ?> alert-dismissible fade show" role="alert">
            <?= $message ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card p-4 shadow-sm">
        <form method="POST">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="client_id" class="form-label">Select Client</label>
                    <select class="form-select" id="client_id" name="client_id" required>
                        <option value="">Choose...</option>
                        <?php foreach ($clients as $client): ?>
                            <option value="<?= $client['client_id'] ?>"><?= htmlspecialchars($client['name']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="invoice_number" class="form-label">Invoice Number</label>
                    <input type="text" class="form-control" id="invoice_number" name="invoice_number" required>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-4 mb-3">
                    <label for="invoice_date" class="form-label">Invoice Date</label>
                    <input type="date" class="form-control" id="invoice_date" name="invoice_date" value="<?= date('Y-m-d') ?>" required>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="due_date" class="form-label">Due Date</label>
                    <input type="date" class="form-control" id="due_date" name="due_date">
                </div>
                <div class="col-md-4 mb-3">
                    <label for="total" class="form-label">Total Amount (GHS)</label>
                    <input type="number" step="0.01" class="form-control" id="total" name="total" required>
                </div>
            </div>

            <div class="mb-3">
                <label for="details" class="form-label">Invoice Details (Brief Summary)</label>
                <input type="text" class="form-control" id="details" name="details">
            </div>
            <div class="mb-3">
                <label for="description" class="form-label">Detailed Description (Line Items)</label>
                <textarea class="form-control" id="description" name="description" rows="3"></textarea>
            </div>
            
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-select" id="status" name="status" required>
                        <option value="Pending">Pending</option>
                        <option value="Paid">Paid</option>
                        <option value="Cancelled">Cancelled</option>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="paid_date" class="form-label">Paid Date (If applicable)</label>
                    <input type="date" class="form-control" id="paid_date" name="paid_date">
                </div>
            </div>

            <button type="submit" class="btn btn-primary mt-3">Create Invoice</button>
            <a href="index.php" class="btn btn-secondary mt-3">Cancel</a>
        </form>
    </div>
</div>

<?php include 'footer.php'; ?>