<?php
include 'db_config.php';
check_login();

$message = '';
$message_type = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = trim($_POST['client_name']);
    $phone = trim($_POST['phone_number']);

    if (empty($name) || empty($phone)) {
        $message = "All fields are required.";
        $message_type = 'danger';
    } else {
        // Basic phone number validation for +233 format
        if (!preg_match("/^\+233[0-9]{9}$/", $phone)) {
            $message = "Phone number must be in the format +233xxxxxxxxxx.";
            $message_type = 'danger';
        } else {
            try {
                $stmt = $pdo->prepare("INSERT INTO clients (name, phone_number) VALUES (?, ?)");
                $stmt->execute([$name, $phone]);
                $message = "Client **$name** added successfully!";
                $message_type = 'success';
            } catch (\PDOException $e) {
                // MySQL error code 23000 typically means a unique constraint violation (duplicate phone)
                if ($e->getCode() == 23000) {
                    $message = "Error: A client with this phone number already exists.";
                } else {
                    $message = "An unexpected database error occurred.";
                    // Log the error: error_log($e->getMessage());
                }
                $message_type = 'danger';
            }
        }
    }
}

// Helper for the Navbar
$active_page = 'add_client';
include 'navbar.php'; // We will define this file in the next section for structure
?>

<div class="container mt-5">
    <h2 class="mb-4">➕ Add New Client</h2>

    <?php if ($message): ?>
        <div class="alert alert-<?= $message_type ?> alert-dismissible fade show" role="alert">
            <?= $message ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="card p-4 shadow-sm">
        <form method="POST">
            <div class="mb-3">
                <label for="client_name" class="form-label">Client Name</label>
                <input type="text" class="form-control" id="client_name" name="client_name" required>
            </div>
            <div class="mb-3">
                <label for="phone_number" class="form-label">Phone Number (+233 format)</label>
                <input type="text" class="form-control" id="phone_number" name="phone_number" placeholder="+233241234567" required>
            </div>
            <button type="submit" class="btn btn-success">Save Client</button>
            <a href="index.php" class="btn btn-secondary">Cancel</a>
        </form>
    </div>
</div>

<?php include 'footer.php'; // Basic footer/script inclusion ?>